#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <stdlib.h>
#include <avr/pgmspace.h>

//  SD  http://www.dharmanitech.com/2009/01/sd-card-interfacing-with-atmega8-fat32.html


//  
#define F_CPU 16000000UL 		        //    (16 MHz)
#define INCDIRECTION		YDIR	    //   XDIR (), YDIR ()
#include "proc.h"						//  
#include "adjectives.h"					//  
#include "keyboard.h"					// 
#include "lcd.h"						//  +   (, , )
#include "draw_spr.h"					//  
#include "chr.h"						//  
#include "sdcard.h"						//   SD 
#include "window.h"						// 



//   
struct myfilestruct{ 				
unsigned char count;				//   
unsigned char filename[16];			// 
unsigned char type;					//   
};


struct myfilestruct ff(uint8_t from,uint8_t sel)

{
unsigned long cluster, sector, firstSector, firstCluster, nextCluster;
struct dir_Structure *dir;
unsigned int i;
unsigned char j,froma=0,printpos=12, c1,c2;
unsigned char cc[16];
unsigned char memoryString[10]; //19 character long string for memory display
struct myfilestruct myfile;

(myfile.count)=0;
memset(myfile.filename,0,sizeof(myfile.filename));


cluster = rootCluster; //root cluster
while(1)
{
   firstSector = getFirstSector (cluster);
   for(sector = 0; sector < sectorPerCluster; sector++)
   {
     SD_readSingleBlock (firstSector + sector);
     for(i=0; i<bytesPerSector; i+=32)
     {
	    dir = (struct dir_Structure *) &buffer[i];
        if(dir->name[0] == EMPTY) return myfile; //indicates end of the file list of the directory
		if((dir->name[0] != DELETED) && (dir->attrib != ATTR_LONG_NAME))
		  {
			 if (from<=(myfile.count)) 
			 {
			 	memset(cc,0,sizeof(cc));
			 	for(j=0; j<11; j++)	cc[j]=(dir->name[j]);
				if (sel==myfile.count) 
				{
					c1=clBlue; c2=clWhite;
					for(j=0; j<11; j++)	(myfile.filename[j])=(dir->name[j]);
					if((dir->attrib != 0x10) && (dir->attrib != 0x08)) 
					myfile.type=1; 
					else 
						if (dir->attrib == 0x10) myfile.type=2; else myfile.type=3;   

				}
				else
				{
					c2=clBlue; c1=clWhite;
				}
				rectangle8(printpos,4,printpos+8,cSCWidth-8,c2);
				put_string8(printpos+1,8,cc,c1, c2);
				if((dir->attrib != 0x10) && (dir->attrib != 0x08))
				{
					pgm_put_string8(printpos+1,80,PSTR("FILE"),c1,c2);
  					ultoa(dir->fileSize,memoryString,10);
 					put_string8(printpos+1,110,memoryString,c1,c2);
				}	
				else 
				pgm_put_string8(printpos+1,80,(dir->attrib == 0x10)? PSTR("DIR") : PSTR("ROOT"),c1, c2);
				printpos=printpos+9;

			 }
			 (myfile.count)++;
		  }
     }
   }

   cluster = (getSetNextCluster (cluster, GET, 0));
   if((cluster == 0)||(cluster > 0x0ffffff6)) return myfile;
  // if(cluster == 0) {transmitString_F(PSTR("Error in getting cluster"));  return 0;}
 }
return myfile;
}


void main (void)
{
unsigned char i=0, key=0, filecnt=0;
struct myfilestruct myfile;


keyboard_init(); 
lcd_init(0xFF);
sdcard_init();

unsigned char f[]="upload.bat";


window(0,0,cSCHeight,cSCWidth,clBlue,PSTR("SELECT FILE"),clWhite);
while (1) 
{
	myfile=ff(0,i);
		rectangle8(cSCHeight-10,0,cSCHeight,cSCWidth,clWhite);
		put_string8(cSCHeight-9,4,myfile.filename,clBlue,clWhite);

		wait_key_pressed();
		key=PINC;
		wait_key_unpressed();
		if (((key & VK_KEY5)==0)&&(i!=0)) i--;
		if (((key & VK_KEY6)==0)&&(i!=((myfile.count)-1))) i++;
		if (((key & VK_KEY1)==0)&&(myfile.type==1))
				{
				myfile.filename[8]=0;//  
				savechar (f,myfile.filename);
				lcd_free();
				boot_start();
				while (1) {};
				}
}

//memoryStatistics();
//findFiles(GET_LIST,0);
//pgm_put_string8(0,20,PSTR("TEST STRING"),0,255);
//unsigned char fileName[]="upload.bat";
//readFile( READ, fileName);




//rectangle8(5,20,40,100,0x127);
//rectangle8(120,120,125,125,0x60);
//pgm_put_string8(0,20,PSTR("TEST STRING"),0,255);

wait_key_pressed();

lcd_free();
_delay_ms(1000);


boot_start();


while (1) {}
}
